import { GREYISH_BROWN, BUTTON_COLOR } from 'constants/colors';

const styles = () => ({
    container: {
        display: 'flex',
        flexDirection: 'column',
        alignItems: 'center'
    },
    title: {
        marginTop: 12,
        marginBottom: 10,
        fontFamily: 'Roboto-Condensed',
        fontSize: 22,
        fontWeight: 'bold',
        fontStyle: 'normal',
        lineHeight: 1.27,
        letterSpacing: 0.68,
        textAlign: 'center',
        color: GREYISH_BROWN
    },
    currentVersion: {
        opacity: 0.8,
        fontFamily: 'Lato',
        fontSize: 16,
        lineHeight: 1.5,
        textAlign: 'center',
        color: GREYISH_BROWN
    },
    reinstallButton: {
        fontSize: 14,
        lineHeight: 1.71,
        letterSpacing: '0.6px',
        padding: '12px 38px 12px 20px'
    },
    tooltipPopper: {
        top: '-18px !important',
        left: '14px !important',
        maxWidth: 300
    },
    tooltipColumn: {
        display: 'flex',
        flexDirection: 'column'
    },
    tooltipLabel: {
        opacity: 0.8,
        fontSize: 16,
        fontFamily: 'Lato',
        fontWeight: 'normal',
        fontStretch: 'normal',
        fontStyle: 'normal',
        lineHeight: 1.5,
        letterSpacing: 'normal',
        color: GREYISH_BROWN
    },
    infoIcon: {
        position: 'absolute',
        top: 17,
        right: 16,
        width: 12,
        height: 12
    },
    btnContainer: {
        position: 'relative',
        display: 'inline-block',
        marginTop: 70
    },
    btnContainerNoMargin: {
        marginTop: 0
    },
    languageContainer: {
        marginTop: 0,
        marginBottom: 10,
        display: 'flex',
        flexDirection: 'row',
        alignItems: 'center',
        width: '300px',
        position: 'relative',
        justifyContent: 'center'
    },
    fwLanguageTitle: {
        fontWeight: 'bold'
    },
    languageInput: {
        color: '#000000 !important',
        border: '0 !important',
        fontFamily: 'Lato, Arial, Helvetica, Helvetica Neue, serif !important',
        display: 'flex',
        flexDirection: 'row',
        alignItems: 'center',
        marginLeft: 10,
        '& img': {
            marginRight: 5,
            marginTop: 4,
            width: 26,
            height: 22
        }
    },
    language: {
        alignSelf: 'flex-end'
    },
    languageSelect: {
        display: 'flex !important',
        '& img': {
            marginRight: 5,
            marginTop: 0,
            width: 26,
            height: 22
        }
    },
    languageInputArrow: {
        color: `${BUTTON_COLOR} !important`
    },
    selectedMenuItem: {
        display: 'none'
    },
    languageMenuItem: {
        color: '#000000',
        '& img': {
            marginRight: 5,
            marginTop: 0,
            width: 26,
            height: 22
        }
    }
});

export default styles;
